<?php

return [
    'title' => 'Mga Setting',
    'general_setting' => 'Mga Pangkalahatang Setting',
    'menu' => 'Lahat ng Mga Setting',
    'email_setting_title' => 'Mga setting ng email',
    'email_setting_description' => 'I-configure ang mga setting ng email',
    'general' => [
        'theme' => 'Tema',
        'title' => 'Pangkalahatang Impormasyon',
        'description' => 'Tingnan at i-update ang impormasyon ng site',
        'rich_editor' => 'Rich Editor',
        'site_title' => 'Pamagat ng site',
        'admin_email' => 'Email ng Admin',
        'seo_block' => 'Konpigurasyon ng SEO',
        'seo_title' => 'Pamagat ng SEO',
        'seo_description' => 'Deskripsyon ng SEO',
        'webmaster_tools_block' => 'Google Webmaster Tools',
        'placeholder' => [
            'site_title' => 'Pamagat ng Site (maximum na 120 karakter)',
            'admin_email' => 'Email ng Admin',
            'seo_title' => 'Pamagat ng SEO (maximum na 120 karakter)',
            'seo_description' => 'Deskripsyon ng SEO (maximum na 120 karakter)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Magpadala ng ulat ng error sa pamamagitan ng email',
        'enable_send_error_reporting_via_email_helper' => 'Kapag pinagana, ang detalyadong ulat ng error ay ipapadala sa mga email address ng administrator kapag may mga kritikal na error sa site',
        'time_zone' => 'Timezone',
        'time_zone_helper' => 'Piliin ang time zone para sa iyong website. Ito ay gagamitin para sa lahat ng pagpapakita ng petsa at oras sa buong sistema',
        'enable' => 'Paganahin',
        'disable' => 'Huwag paganahin',
        'disabled_helper' => 'Hindi maaaring i-disable ang email template na ito!',
        'enable_cache_site_map' => 'Paganahin ang pag-cache ng sitemap',
        'cache_time_site_map' => 'Timeout ng cache ng sitemap (sa mga minuto)',
        'admin_logo' => 'Logo ng admin',
        'admin_favicon' => 'Favicon ng admin',
        'admin_title' => 'Pamagat ng admin',
        'admin_title_placeholder' => 'Pamagat na ipapakita sa tab ng browser',
        'admin_appearance_title' => 'Hitsura ng admin',
        'admin_appearance_description' => 'Pagtatakda ng hitsura ng admin tulad ng editor, wika...',
        'seo_block_description' => 'Pagtatakda ng pamagat ng site, meta description ng site, keyword ng site para sa pag-optimize ng SEO',
        'webmaster_tools_description' => 'Ang Google Search Console ay libreng web tool na ibinibigay ng Google na tumutulong sa mga may-ari ng website na subaybayan ang performance ng kanilang site sa mga resulta ng Google Search.',
        'yes' => 'Oo',
        'no' => 'Hindi',
        'show_on_front' => 'Ang iyong homepage ay nagpapakita ng',
        'select' => '— Pumili —',
        'show_site_name' => 'Ipakita ang pangalan ng site pagkatapos ng pamagat ng pahina, pinaghihiwalay ng "-"',
        'locale' => 'Wika ng site',
        'locale_direction' => 'Direksyon ng wika ng front site',
        'minutes' => 'mga minuto',
        'redirect_404_to_homepage' => 'I-redirect ang lahat ng Not Found requests sa homepage',
    ],
    'admin_appearance' => [
        'title' => 'Hitsura ng admin',
        'description' => 'Tingnan at i-update ang logo, favicon, layout,...',
        'layout' => 'Layout',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'Pahalang',
        'vertical' => 'Patayo',
        'show_menu_item_icon' => 'Ipakita ang icon ng menu item',
        'language' => 'Wika ng admin panel',
        'theme_mode' => 'Tema mode',
        'dark' => 'Madilim',
        'light' => 'Maliwanag',
        'container_width' => [
            'title' => 'Lapad ng container',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'Default',
            'large' => 'Malaki',
            'full' => 'Buong',
        ],
        'form' => [
            'admin_logo' => 'Logo ng admin',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'Taas ng logo (px)',
            'admin_logo_max_height_helper' => 'Itakda ang taas ng logo sa pixels. Ang default na halaga ay :default.',
            'admin_favicon' => 'Favicon ng admin',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'Uri ng favicon ng admin',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'Pamagat ng admin',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'Pamagat na ipapakita sa tab ng browser',
            'admin_login_screen_backgrounds' => 'Mga background ng login screen (~1366 x 768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'Wika ng admin',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'Direksyon ng wika ng admin',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'Rich Editor',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'Pangunahing font',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'Pangunahing kulay',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'Pangalawang kulay',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'Kulay ng heading',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'Kulay ng teksto',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'Kulay ng link',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'Kulay ng link sa hover',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => 'Ipakita ang icon ng menu item',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'Custom CSS',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'Custom JS',
            'custom_header_js' => 'Header JS',
            'custom_header_js_placeholder' => 'JavaScript sa header ng pahina, i-wrap ito sa loob ng &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'Body JS',
            'custom_body_js_placeholder' => 'JavaScript sa body ng pahina, i-wrap ito sa loob ng &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'Footer JS',
            'custom_footer_js_placeholder' => 'JavaScript sa footer ng pahina, i-wrap ito sa loob ng &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Mga Datatable',
        'description' => 'Mga setting para sa mga datatable',
        'form' => [
            'show_column_visibility' => 'Ipakita ang column visibility bilang default',
            'show_column_visibility_helper' => 'Paganahin ang button ng column visibility toggle sa mga data table upang payagan ang mga user na ipakita/itago ang mga column',
            'show_export_button' => 'Ipakita ang export button bilang default',
            'show_export_button_helper' => 'Ipakita ang mga opsyon ng export (CSV, Excel, PDF) sa mga data table para sa pag-download ng data ng table',
            'pagination_type' => 'Uri ng pagination',
            'pagination_type_helper' => 'Piliin kung paano ipapakita ang mga pagination controls: Ang Default ay nagpapakita ng mga numero ng pahina, ang Dropdown ay nagpapakita ng compact dropdown selector',
            'default' => 'Default',
            'dropdown' => 'Dropdown',
            'enable_responsive' => 'Paganahin ang table responsive',
            'enable_responsive_helper' => 'Awtomatikong i-adjust ang mga column ng table upang umangkop sa iba\'t ibang laki ng screen para sa mas magandang mobile experience',
        ],
    ],
    'email' => [
        'subject' => 'Paksa',
        'content' => 'Nilalaman',
        'title' => 'Setting para sa email template',
        'description' => 'Ang email template ay gumagamit ng HTML at mga system variables.',
        'reset_to_default' => 'I-reset sa default',
        'back' => 'Bumalik sa mga setting',
        'reset_success' => 'Matagumpay na na-reset pabalik sa default',
        'confirm_reset' => 'Kumpirmahin upang i-reset ang email template?',
        'confirm_message' => 'Talagang gusto mo bang i-reset ang email template na ito pabalik sa default?',
        'continue' => 'Magpatuloy',
        'sender_name' => 'Pangalan ng nagpadala',
        'sender_name_placeholder' => 'Pangalan',
        'sender_name_helper' => 'Ang pangalang lalabas sa From field ng mga email na ipinapadala ng system',
        'sender_email' => 'Email ng nagpadala',
        'sender_email_placeholder' => 'Email address (hal. :default)',
        'sender_email_helper' => 'Ang email address na gagamitin bilang nagpadala para sa lahat ng email na ipinapadala ng system',
        'mailer' => 'Mailer',
        'port' => 'Port',
        'port_placeholder' => 'Hal: 587',
        'port_helper' => 'Ang port na ginagamit ng iyong mail server (mga karaniwang port: 25, 465, 587)',
        'host' => 'Host',
        'host_placeholder' => 'Hal: smtp.gmail.com',
        'host_helper' => 'SMTP host address',
        'username' => 'Username',
        'username_placeholder' => 'Username upang mag-login sa mail server',
        'username_helper' => 'Ang iyong username sa pag-login sa mail server',
        'password' => 'Password',
        'password_placeholder' => 'Password upang mag-login sa mail server',
        'password_helper' => 'Ang iyong password sa pag-login sa mail server',
        'encryption' => 'Encryption',
        'encryption_placeholder' => 'Pumili ng uri ng encryption',
        'encryption_helper' => 'Piliin ang paraan ng encryption para sa secure na pagpapadala ng email',
        'encryption_none' => 'Wala',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Mga Tip sa Pag-setup ng Email',
        'setup_tip_gmail' => 'Para sa Gmail: Gumamit ng smtp.gmail.com bilang host, port 587 na may TLS o port 465 na may SSL. Paganahin ang "Less secure app access" o gumamit ng App Password.',
        'setup_tip_port' => 'Mga karaniwang port: 25 (walang encryption), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternatibo).',
        'setup_tip_encryption' => 'Gumamit ng TLS para sa port 587 (inirerekomenda), SSL para sa port 465, o None para sa port 25 (hindi inirerekomenda para sa production).',
        'setup_tip_test' => 'Palaging gumamit ng "Send Test Email" button upang i-verify ang iyong configuration bago mag-save.',
        'setup_tip_mailgun' => 'Para sa mas mahusay na deliverability, isaalang-alang ang paggamit ng mga serbisyo ng email tulad ng Mailgun, SendGrid, o Amazon SES sa halip na SMTP.',
        'queue_warning_title' => 'Kinakailangan ang Konpigurasyon ng Queue',
        'queue_warning_description' => 'Ang iyong email queue ay kasalukuyang naka-configure na gumamit ng ":default" driver, ngunit maaaring hindi tumatakbo ang iyong queue worker. Nangangahulugan ito na hindi maipapadala ang mga email hanggang sa mag-set up ka ng queue worker.',
        'queue_warning_action' => 'Upang magpadala ng mga email kaagad nang walang queue worker, itakda ang QUEUE_CONNECTION=sync sa iyong .env file. Kung hindi, siguraduhing tumatakbo ang iyong queue worker gamit ang "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Matuto pa tungkol sa Laravel Queues</a>.',
        'mail_gun_domain' => 'Domain',
        'mail_gun_domain_placeholder' => 'Hal: mg.yourdomain.com',
        'mail_gun_domain_helper' => 'Ang domain name na iyong nirehistro sa Mailgun',
        'mail_gun_secret' => 'Secret',
        'mail_gun_secret_placeholder' => 'Hal: key-0123456789abcdef0123456789abcdef',
        'mail_gun_secret_helper' => 'Ang iyong Mailgun API key',
        'mail_gun_endpoint' => 'Endpoint',
        'mail_gun_endpoint_placeholder' => 'Hal: api.mailgun.net',
        'mail_gun_endpoint_helper' => 'Mailgun API endpoint (api.mailgun.net para sa US, api.eu.mailgun.net para sa EU)',
        'log_channel' => 'Log channel',
        'log_channel_helper' => 'Pumili kung aling logging channel ang gagamitin para sa mga email log',
        'sendmail_path' => 'Sendmail Path',
        'local_domain' => 'Lokal na domain',
        'local_domain_placeholder' => 'Maaaring walang laman. Kailangan itakda sa iyong domain kapag gumagamit ng SMTP Relay. Hal. your-domain.com',
        'local_domain_helper' => 'Ang domain na gagamitin upang kilalanin ang server kapag nakikipag-ugnayan sa mga remote SMTP servers',
        'ses_key' => 'Key',
        'ses_key_placeholder' => 'Hal: AKIAIOSFODNN7EXAMPLE',
        'ses_key_helper' => 'Ang iyong AWS access key ID',
        'ses_secret' => 'Secret',
        'ses_secret_placeholder' => 'Hal: wJalrXUtnFEMI/K7MDENG/bPxRfiCYEXAMPLEKEY',
        'ses_secret_helper' => 'Ang iyong AWS secret access key',
        'ses_region' => 'Region',
        'ses_region_placeholder' => 'Hal: us-east-1',
        'ses_region_helper' => 'Ang AWS region kung saan naka-configure ang iyong SES service',
        'postmark_token' => 'Token',
        'postmark_token_placeholder' => 'Hal: 9a734df7-1c85-4b35-a98a-3d24cac1db1e',
        'postmark_token_helper' => 'Ang iyong Postmark server token',
        'resend_key' => 'API Key',
        'resend_key_placeholder' => 'Hal: re_123456789012345678901234567890',
        'resend_key_helper' => 'Ang iyong Resend API key',
        'email_templates' => 'Mga email template',
        'email_templates_description' => 'Mga email template na gumagamit ng HTML at mga system variables.',
        'email_template_settings' => 'Mga Setting ng Email Template',
        'email_template_settings_description' => 'Tingnan at i-update ang iyong mga setting ng email templates',
        'email_rules' => 'Mga panuntunan ng email',
        'email_rules_description' => 'I-configure ang mga panuntunan ng email para sa validation',
        'base_template' => 'Base template',
        'base_template_description' => 'Base template para sa lahat ng email',
        'template_header' => 'Header ng email template',
        'template_header_description' => 'Template para sa header ng mga email',
        'template_footer' => 'Footer ng email template',
        'template_footer_description' => 'Template para sa footer ng mga email',
        'default' => 'Default',
        'template_off_status_helper' => 'Ang email template na ito ay naka-off.',
        'blacklist_email_domains' => 'Mga Blacklisted na Email Domain',
        'blacklist_email_domains_helper' => 'Magpasok ng listahan ng mga email domain na ib-blacklist. Hal. gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Mga Blacklisted na Email Address',
        'blacklist_specified_emails_helper' => 'Magpasok ng listahan ng mga partikular na email address na ib-blacklist. Hal. mail@example.com.',
        'exception_emails' => 'Mga Exception na Email',
        'exception_emails_helper' => 'Ang mga email na ito ay hindi kasama sa mga panuntunan ng validation.',
        'email_rules_strict' => 'Mahigpit na Validation ng Email',
        'email_rules_strict_helper' => 'Magsagawa ng RFC-like na email validation na may mahihigpit na panuntunan.',
        'email_rules_dns' => 'DNS Check Validation',
        'email_rules_dns_helper' => 'Suriin kung may mga DNS records na nagsasaad na tumatanggap ang server ng mga email.',
        'email_rules_spoof' => 'Pagtuklas ng Spoofing',
        'email_rules_spoof_helper' => 'Tuklasin ang mga potensyal na pagtatangka ng email spoofing.',
        'template_turn_off' => 'I-click upang i-off ang email template na ito',
        'template_turn_on' => 'I-click upang i-on ang email template na ito',
        'turn_on_success_message' => 'Matagumpay na na-on ang email template!',
        'turn_off_success_message' => 'Matagumpay na na-off ang email template!',
        'email_template_status' => 'Status ng email template',
        'email_template_status_description' => 'I-on/off ang email template',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Kung hindi itinakda, kukunin ito mula sa admin logo sa Admin -> Settings -> Admin Appearance -> Logo.',
        'email_template_copyright_text_helper_text' => 'Kung hindi itinakda, kukunin ito mula sa copyright ng theme options sa Admin -> Appearance -> Theme Options -> General -> Copyright.',
        'email_template_email_contact' => 'Email address ng contact',
        'email_template_email_contact_helper_text' => 'Kung hindi itinakda, kukunin ito mula sa sender email sa Admin -> Settings -> Email',
        'email_template_social_links' => 'Mga Social Link',
        'email_template_copyright_text' => 'Copyright',
        'image_upload_supported' => 'Sumusuporta lamang ng PNG, JPG, JPEG, at GIF na mga format.',
        'email_template_custom_css' => 'Custom CSS ng email template',
        'social_links' => [
            'name' => 'Pangalan',
            'icon' => 'Icon',
            'icon_image' => 'Icon Image (Sumusuporta lamang ng PNG, JPG, JPEG, at GIF na mga format.)',
            'url' => 'URL',
            'image' => 'Larawan',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Lisensya',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Media',
        'driver' => 'Driver',
        'description' => 'Mga setting para sa media',
        'local_disk' => 'Lokal na disk',
        'aws_access_key_id' => 'AWS Access Key ID',
        'aws_secret_key' => 'AWS Secret Key',
        'aws_default_region' => 'AWS Default Region',
        'aws_bucket' => 'AWS Bucket',
        'aws_url' => 'AWS URL',
        'aws_endpoint' => 'AWS Endpoint (Opsyonal)',
        'use_path_style_endpoint' => 'Gumamit ng path style endpoint',
        'r2_access_key_id' => 'R2 Access Key ID',
        'r2_secret_key' => 'R2 Secret Key',
        'r2_bucket' => 'R2 Bucket',
        'r2_url' => 'R2 URL',
        'r2_endpoint' => 'R2 Endpoint',
        'do_spaces_access_key_id' => 'DO Spaces Access Key ID',
        'do_spaces_secret_key' => 'DO Spaces Secret Key',
        'do_spaces_default_region' => 'DO Spaces Default Region',
        'do_spaces_bucket' => 'DO Spaces Bucket',
        'do_spaces_endpoint' => 'DO Spaces Endpoint',
        'do_spaces_cdn_enabled' => 'Naka-enable ba ang DO Spaces CDN?',
        'do_spaces_cdn_enabled_helper' => 'Kapag pinagana, ang mga file ng media ay ihahain sa pamamagitan ng mga puwang ng DigitalOcean CDN para sa mas mabilis na paghahatid ng nilalaman ng pandaigdig. Maaari mong opsyonal na i -configure ang isang pasadyang domain ng CDN sa ibaba.',
        'media_do_spaces_cdn_custom_domain' => 'Custom domain ng Do Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'Wasabi Access Key ID',
        'wasabi_secret_key' => 'Wasabi Secret Key',
        'wasabi_default_region' => 'Wasabi Default Region',
        'wasabi_bucket' => 'Wasabi Bucket',
        'wasabi_root' => 'Wasabi Root',
        'wasabi_root_helper' => 'Upang muling gamitin ang mga umiiral na larawan, itakda lang ang Wasabi root bilang "/", pagkatapos ay i-upload ang lahat ng kasalukuyang file mula sa public/storage sa iyong Wasabi root directory.',
        'backblaze_access_key_id' => 'Backblaze Access Key ID',
        'backblaze_secret_key' => 'Backblaze Secret Key',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Backblaze Default Region',
        'backblaze_url' => 'Backblaze URL',
        'backblaze_endpoint' => 'Backblaze Endpoint',
        'backblaze_cdn_enabled' => 'Naka-enable ba ang Backblaze CDN?',
        'backblaze_cdn_enabled_helper' => 'Kapag pinagana, ang mga file ng media ay ihahain sa pamamagitan ng isang CDN para sa mas mabilis na paghahatid ng nilalaman ng pandaigdig. Dapat mong i -configure ang isang pasadyang domain ng CDN sa ibaba (hal., CloudFlare CDN o backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Custom domain ng Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'Default na placeholder image',
        'enable_chunk' => 'Paganahin ang chunk upload',
        'chunk_size' => 'Laki ng chunk (Bytes)',
        'chunk_size_placeholder' => 'Default: 1048576 ~ 1MB',
        'max_file_size' => 'Maximum na laki ng file ng chunk (MB)',
        'max_file_size_placeholder' => 'Default: 1048576 ~ 1GB',
        'enable_watermark' => 'Paganahin ang watermark',
        'enable_watermark_helper' => 'Kapag pinagana, ang isang watermark ay awtomatikong idaragdag sa mga bagong na -upload na mga imahe sa mga napiling folder. Hindi ito nakakaapekto sa umiiral na mga imahe.',
        'watermark_source' => 'Larawan ng watermark',
        'watermark_source_helper' => 'Sumusuporta lamang ng PNG, JPG, at JPEG na mga format. Dapat gumamit ka ng larawan na mas mababa sa 200x200px at laki na mas maliit sa 50KB.',
        'watermark_size' => 'Laki ng watermark (%)',
        'watermark_size_placeholder' => 'Default: 10 (%)',
        'watermark_opacity' => 'Opacity ng Watermark (%)',
        'watermark_opacity_placeholder' => 'Default: 70 (%)',
        'watermark_position' => 'Posisyon ng watermark',
        'watermark_position_x' => 'Posisyon ng watermark X',
        'watermark_position_y' => 'Posisyon ng watermark Y',
        'watermark_position_top_left' => 'Itaas na kaliwa',
        'watermark_position_top_right' => 'Itaas na kanan',
        'watermark_position_bottom_left' => 'Ibaba na kaliwa',
        'watermark_position_bottom_right' => 'Ibaba na kanan',
        'watermark_position_center' => 'Gitna',
        'turn_off_automatic_url_translation_into_latin' => 'I-off ang awtomatikong pagsasalin ng URL sa Latin',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Kapag pinagana, ang mga File URL ay hindi awtomatikong isasalin sa mga character na Latin, na pinapanatili ang mga orihinal na character mula sa mga hindi titik na latin.',
        'bunnycdn_hostname' => 'Hostname',
        'bunnycdn_zone' => 'Pangalan ng Zone (Ang pangalan ng iyong storage zone)',
        'bunnycdn_key' => 'FTP & API Access Password (Ang storage zone API Access Password)',
        'bunnycdn_region' => 'Region (Ang region ng storage zone)',
        'optional' => 'Opsyonal',
        'sizes' => 'Mga laki ng thumbnail ng media',
        'media_sizes_helper' => 'Itakda ang width o height sa 0 kung nais mo lang mag-crop ayon sa width o height.',
        'width' => 'Lapad',
        'height' => 'Taas',
        'default_size_value' => 'Default: :size',
        'all' => 'Lahat',
        'all_helper_text' => 'Kung alisin mo ang lahat ng folder, aaplicable ito sa lahat ng folder.',
        'media_folders_can_add_watermark' => 'Magdagdag ng watermark para sa mga larawan sa mga folder:',
        'max_upload_filesize' => 'Maximum na laki ng file na maaaring i-upload (MB)',
        'max_upload_filesize_placeholder' => 'Default: :size, dapat mas mababa sa :size.',
        'max_upload_filesize_helper' => 'Ang iyong server ay nagpapahintulot ng pag-upload ng mga file na maximum na :size, maaari mong baguhin ang halagang ito upang limitahan ang laki ng file na maaaring i-upload.',
        'image_processing_library' => 'Library ng pagproseso ng larawan',
        'use_original_name_for_file_path' => 'Gumamit ng orihinal na pangalan para sa file path',
        'use_original_name_for_file_path_helper' => 'Kapag pinagana, i -upload ang mga file ay panatilihin ang kanilang mga orihinal na pangalan. Kapag hindi pinagana, ang mga pangalan ng file ay mai-convert sa mga slug ng url-friendly (hal., "Ang aking larawan.jpg" ay nagiging "my-photo.jpg").',
        'keep_original_file_size_and_quality' => 'Panatilihin ang orihinal na laki at kalidad ng file',
        'keep_original_file_size_and_quality_helper' => 'Kapag pinagana, ang mga nai -upload na mga imahe ay hindi mababago o na -optimize, pinapanatili ang kanilang orihinal na kalidad at laki ng file. Kapag hindi pinagana, ang mga imahe ay maaaring mai -compress at baguhin ang laki batay sa iyong mga setting.',
        'update_thumbnail_sizes_warning' => 'Pagkatapos ayusin ang mga laki ng thumbnail, dapat mong i-click ang button na ":button_text" upang i-refresh ang mga ito.',
        'thumbnail_crop_position' => 'Posisyon ng pag-crop ng thumbnail',
        'thumbnail_crop_position_left' => 'Kaliwa',
        'thumbnail_crop_position_center' => 'Gitna',
        'thumbnail_crop_position_right' => 'Kanan',
        'thumbnail_crop_position_top' => 'Itaas',
        'thumbnail_crop_position_bottom' => 'Ibaba',
        'thumbnail_crop_position_helper' => 'Ang setting na ito ay ginagamit upang i-crop ang larawan kapag gumagawa ng mga thumbnail. Ito ay ic-crop mula sa posisyong ito hanggang sa mapunan ang larawan.',
        'user_can_only_view_own_media' => 'Ang mga user ay maaari lamang tumingin ng kanilang sariling media',
        'user_can_only_view_own_media_helper' => 'Kapag naka-enable, ang mga user ay maaari lamang tumingin ng kanilang sariling media, habang ang mga super admin ay makakakita ng lahat ng media.',
        'enable_thumbnail_sizes' => 'Paganahin ang mga laki ng thumbnail',
        'enable_thumbnail_sizes_helper' => 'Paganahin ang opsyong ito upang gumawa ng mga thumbnail para sa mga larawan. Kung ito ay naka-disable, ang system ay hindi gagawa ng mga thumbnail para sa mga larawan at palaging gagamit ng buong laki ng larawan.',
        'convert_image_to_webp' => 'I-convert ang JPG, JPEG, PNG na larawan sa WebP',
        'convert_image_to_webp_helper' => 'Ang WebP ay isang modernong format ng larawan na nagbibigay ng superior na lossless at lossy compression para sa mga larawan sa web. Ito ay sinusuportahan sa Chrome, Firefox, Edge, at Opera. Ang larawan ay ico-convert sa WebP format kapag nag-upload. Ito ay inilalapat lamang para sa JPG, JPEG, PNG na mga larawan.',
        'reduce_large_image_size' => 'Bawasan ang laki ng malalaking larawan kapag nag-upload',
        'reduce_large_image_size_helper' => 'Kapag naka-enable, ang system ay babawasan ang laki ng malalaking larawan kapag nag-upload, inilalapat para sa JPG, JPEG, PNG, WebP na larawan. Ang maximum na lapad at taas ng larawan ay ire-resize sa mga halagang itinakda mo sa ibaba.',
        'image_max_width' => 'Maximum na lapad ng larawan (px)',
        'image_max_height' => 'Maximum na taas ng larawan (px)',
        'image_max_width_placeholder' => 'Iwanang blangko upang panatilihin ang orihinal na lapad',
        'image_max_height_placeholder' => 'Iwanang blangko upang panatilihin ang orihinal na taas',
        'image_max_width_helper' => 'Itakda ang maximum na lapad ng larawan sa pixels. Ang orihinal na lapad ay papanatilihin kung ang field na ito ay walang laman.',
        'image_max_height_helper' => 'Itakda ang maximum na taas ng larawan sa pixels. Ang orihinal na taas ay papanatilihin kung ang field na ito ay walang laman.',
        'customize_upload_path' => 'I-customize ang upload path',
        'customize_upload_path_helper' => 'I-customize ang upload path para sa mga media file. Bilang default, ang system ay mag-upload ng mga file sa ":path" folder.',
        'upload_path' => 'Upload path',
        'upload_path_placeholder' => 'Halimbawa: uploads',
        'upload_path_helper' => 'Ang folder na iyon ay gagawin sa /public. Ang default na folder ay ":folder". Pagkatapos ay iu-upload ito sa "/public/:folder".',
        'upload_path_warning' => 'Ang system ay hindi maglilipat ng mga umiiral na file sa bagong folder. Kung nais mong ilipat ang mga umiiral na file sa bagong folder, kailangan mong gawin ito nang mano-mano.',
        'convert_file_name_to_uuid' => 'I-convert ang pangalan ng file sa UUID',
        'convert_file_name_to_uuid_helper' => 'Kapag naka-enable, ang system ay ico-convert ang pangalan ng file sa UUID kapag nag-upload. Ito ay kapaki-pakinabang upang maiwasan ang mga duplicate na pangalan ng file at mas mahusay na seguridad.',
        's3_path' => 'Custom S3 Path (Opsyonal)',
        's3_path_placeholder' => 'Opsyonal na custom path sa S3 bucket (hal., uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'I-save ang mga setting',
    'template' => 'Template',
    'description' => 'Deskripsyon',
    'enable' => 'Paganahin',
    'send' => 'Ipadala',
    'test_email_description' => 'Upang magpadala ng test email, siguraduhing na-update mo na ang mga configuration para sa pagpapadala ng email!',
    'test_email_input_placeholder' => 'Ipasok ang email address kung saan mo gustong magpadala ng test email.',
    'test_email_modal_title' => 'Magpadala ng test email',
    'test_send_mail' => 'Magpadala ng test email',
    'test_email_send_success' => 'Matagumpay na naipadala ang email!',
    'locale_direction_ltr' => 'Kaliwa Patungo sa Kanan',
    'locale_direction_rtl' => 'Kanan Patungo sa Kaliwa',
    'emails_warning' => 'Maaari kang magdagdag ng maximum na :count email',
    'email_add_more' => 'Magdagdag pa',
    'generate' => 'Gumawa',
    'generate_thumbnails' => 'Gumawa ng mga thumbnail',
    'generate_thumbnails_success' => 'Matagumpay na nagawa ang mga thumbnail. :count na mga file ang nagawa!',
    'generate_thumbnails_error' => 'Hindi namin magawang muling gumawa ng mga thumbnail para sa :count na mga file!',
    'generate_thumbnails_description' => 'Sigurado ka bang gusto mong muling gumawa ng mga thumbnail para sa lahat ng larawan? Maaaring tumagal ito. Mangyaring huwag umalis sa pahinang ito hanggang sa matapos ang proseso.',
    'enable_chunk_description' => 'Ang chunk size upload ay ginagamit upang mag-upload ng malaking laki ng file.',
    'watermark_description' => 'BABALA: Ang watermark ay idinadagdag lamang sa mga bagong na-upload na larawan, hindi ito idadagdag sa mga umiiral na larawan. Ang pag-disable ng watermark ay hindi mag-aalis ng watermark mula sa mga umiiral na larawan.',
    'submit' => 'Isumite',
    'back' => 'Bumalik',
    'enter_sample_value' => 'Magpasok ng mga halimbawa ng halaga para sa pagsubok',
    'preview' => 'Preview',
    'media_size_width' => 'Ang lapad ng laki ng :size ay dapat na mas malaki sa 0',
    'media_size_height' => 'Ang taas ng laki ng :size ay dapat na mas malaki sa 0',
    'security' => [
        'title' => 'Mga Setting ng Seguridad',
        'description' => 'Suriin at i-configure ang mga setting ng seguridad para sa iyong website.',
        'menu_description' => 'Pamahalaan ang seguridad ng cookie at HTTP headers',
        'status_secure' => 'Lahat ng setting ng seguridad ay wastong naka-configure!',
        'status_insecure' => 'Ang ilang setting ng seguridad ay nangangailangan ng pansin!',
        'current_settings' => 'Kasalukuyang Mga Setting ng Seguridad',
        'status' => 'Katayuan',
        'setting' => 'Setting',
        'current_value' => 'Kasalukuyang Halaga',
        'recommended_value' => 'Inirerekomenda',
        'session_http_only' => 'HttpOnly Cookie Flag',
        'session_http_only_description' => 'Pinipigilan ang JavaScript sa pag-access ng mga session cookie (protektado laban sa XSS attacks)',
        'session_secure_cookie' => 'Secure Cookie Flag',
        'session_secure_cookie_description' => 'Tinitiyak na ang mga cookie ay ipinapadala lamang sa mga HTTPS connection',
        'session_same_site' => 'SameSite Cookie Flag',
        'session_same_site_description' => 'Pinipigilan ang CSRF attacks sa pamamagitan ng paghihigpit kung kailan ipinapadala ang mga cookie',
        'http_security_headers' => 'HTTP Security Headers',
        'http_security_headers_description' => 'Nagdadagdag ng mga security header upang protektahan laban sa mga karaniwang kahinaan sa web',
        'https_warning' => 'Ang iyong site ay hindi gumagamit ng HTTPS',
        'https_warning_description' => 'Ang ilang feature ng seguridad tulad ng secure cookies ay nangangailangan ng HTTPS. Isaalang-alang ang pag-enable ng SSL para sa iyong website.',
        'how_to_fix' => 'Paano Ayusin ang Mga Isyu sa Seguridad',
        'env_file_location' => 'I-edit ang iyong .env file na matatagpuan sa:',
        'add_to_env' => 'Mga Setting na Idadagdag',
        'required_settings' => 'Mga Kinakailangang Setting ng Seguridad',
        'for_https_sites' => 'Para sa mga HTTPS Site Lamang',
        'copy' => 'Kopyahin',
        'copy_settings' => 'Kopyahin ang Lahat ng Setting',
        'copied' => 'Nakopya!',
        'steps' => 'Mga Hakbang upang Ilapat ang mga Setting',
        'step_1' => 'Buksan ang iyong .env file sa isang text editor',
        'step_2' => 'Idagdag o i-update ang mga setting ng seguridad na ipinapakita sa itaas',
        'step_3' => 'I-save ang .env file',
        'step_4' => 'I-clear ang cache gamit ang Admin Panel → Platform Administration → Cache Management',
        'security_headers_info' => 'Impormasyon ng Security Headers',
        'security_headers_list' => 'Kapag naka-enable, ang mga sumusunod na header ay idinadagdag sa lahat ng mga tugon:',
        'header_nosniff' => 'Pinipigilan ang mga browser sa paghuhula ng mga uri ng nilalaman',
        'header_frame' => 'Nag-protekta laban sa mga clickjacking attack',
        'header_xss' => 'Nag-enable ng proteksyon ng XSS sa browser',
        'header_referrer' => 'Kinokontrol kung gaano karaming impormasyon ng referrer ang ipinapadala',
        'learn_more' => 'Para sa mas detalyadong impormasyon, tingnan ang :documentation',
        'documentation' => 'dokumentasyon ng seguridad',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'I-configure ang caching para sa na-optimize na bilis',
        'form' => [
            'cache_admin_menu' => 'I-cache ang admin menu',
            'cache_admin_menu_helper' => 'I-cache ang admin menu para sa na-optimize na bilis. Ang opsyong ito ay dapat na i-disable kung ikaw ay nag-develop o nag-customize ng admin menu.',
            'enable_cache_site_map' => 'I-cache ang sitemap',
            'enable_cache_site_map_helper' => 'Ang sitemap :url ay dapat na i-cache dahil sa malaking bilang ng mga pahina. Kung mayroon kang kaunting bilang ng mga pahina, maaari mong i-disable ang opsyong ito.',
            'cache_time_site_map' => 'Timeout ng cache ng sitemap (sa mga minuto)',
            'cache_front_menu' => 'I-cache ang front menu',
            'cache_front_menu_helper' => 'I-cache ang front menu para sa na-optimize na bilis',
            'cache_user_avatar' => 'I-cache ang avatar ng user',
            'cache_user_avatar_helper' => 'Para sa mga user na walang avatar, ang system ay gagawa ng mga avatar mula sa kanilang mga username. Ang mga avatar ay ic-cache para sa na-optimize na bilis at hindi na muling gagawin.',
            'shortcode_cache_enabled' => 'I-cache ang mga shortcode (UI blocks)',
            'shortcode_cache_enabled_helper' => 'Paganahin ang caching para sa mga shortcode upang mapabuti ang performance. Kapag naka-enable, ang mga shortcode ay ic-cache upang mabawasan ang oras ng rendering.',
            'shortcode_cache_warning' => '<strong>⚠️ Mahalagang Paalala:</strong><br>• Ang mga shortcode na naglalaman ng mga form (contact forms, newsletter subscriptions, atbp.) ay awtomatikong hindi ic-cache upang mapanatili ang functionality.<br>• Ang mga shortcode na may dynamic JavaScript content ay dapat na manu-manong i-disable ang caching.<br>• Upang i-disable ang caching para sa mga partikular na shortcode, idagdag ang <code>Enable caching: No</code> sa configuration ng shortcode.<br>• Ang mga form na may CSRF tokens, reCAPTCHA, o iba pang dynamic na elemento ay awtomatikong natuklas at hindi kasama sa caching.',
            'shortcode_cache_ttl' => 'Tagal ng cache (seconds)',
            'shortcode_cache_ttl_helper' => 'Ang tagal ng pag-cache ng lahat ng shortcode. Ang default ay 1800 seconds (30 minuto).',
            'widget_cache_enabled' => 'I-cache ang mga widget',
            'widget_cache_enabled_helper' => 'Paganahin ang caching para sa mga widget upang mapabuti ang performance. Kapag naka-enable, ang mga widget ay ic-cache upang mabawasan ang oras ng rendering.',
            'widget_cache_warning' => '<strong>⚠️ Mahalagang Paalala:</strong><br>• Ang mga widget na naglalaman ng mga form (contact forms, newsletter subscriptions, atbp.) ay awtomatikong hindi ic-cache upang mapanatili ang functionality.<br>• Ang mga widget na may dynamic JavaScript content ay dapat na manu-manong i-disable ang caching.<br>• Upang i-disable ang caching para sa mga partikular na widget, itakda ang <code>Enable caching: No</code> sa configuration ng widget.<br>• Ang mga form na may CSRF tokens, reCAPTCHA, o iba pang dynamic na elemento ay awtomatikong natuklas at hindi kasama sa caching.',
            'widget_cache_ttl' => 'Tagal ng cache (seconds)',
            'widget_cache_ttl_helper' => 'Ang tagal ng pag-cache ng lahat ng widget. Ang default ay 1800 seconds (30 minuto).',
            'plugin_cache_enabled' => 'I-cache ang mga naka-install na plugin',
            'plugin_cache_enabled_helper' => 'I-cache ang listahan ng mga naka-install na plugin para sa pinabuting performance. Kapag naka-enable, ang system ay mag-cache ng listahan ng plugin sa loob ng 30 minuto upang mabawasan ang mga file system scan.',
        ],
    ],
    'appearance' => [
        'title' => 'Hitsura',
    ],
    'panel' => [
        'common' => 'Karaniwan',
        'general' => 'Pangkalahatan',
        'general_description' => 'Tingnan at i-update ang iyong mga pangkalahatang setting at i-activate ang license',
        'email' => 'Email',
        'email_description' => 'Tingnan at i-update ang iyong mga setting ng email at mga email template',
        'media' => 'Media',
        'media_description' => 'Tingnan at i-update ang iyong mga setting ng media',
        'system' => 'System',
        'system_updater' => 'System Updater',
        'system_updater_description' => 'I-update ang iyong system sa pinakabagong bersyon',
        'others' => 'Iba pa',
    ],
    'saving' => 'Nagse-save...',
    'generating_media_thumbnails' => 'Gumagawa ng mga thumbnail ng media...',
    'test_email_template' => 'Subukan ang email template',
    'select_email_template' => 'Pumili ng email template',
    'enums' => [
        'data_retention_period' => [
            'Hindi kailanman',
            '1 Araw',
            3 => '3 Araw',
            7 => '1 Linggo',
            30 => '1 Buwan',
            90 => '3 Buwan',
            180 => '6 Buwan',
            365 => '1 Taon',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'Ang :attribute ay dapat na wastong AWS region (hal., us-east-1, eu-west-1).',
    ],
    'phone_number' => [
        'title' => 'Phone Number',
        'description' => 'Configure phone number field settings',
        'enable_country_code' => 'Enable Country Code Selection',
        'enable_country_code_helper' => 'When enabled, phone number fields will display a country code selector with automatic country detection.',
        'available_countries' => 'Available Countries',
        'all' => 'All',
        'all_helper_text' => 'Select all countries to be available in the phone country code selector.',
        'min_length' => 'Minimum Length',
        'min_length_helper' => 'Minimum number of characters required for phone numbers.',
        'max_length' => 'Maximum Length',
        'max_length_helper' => 'Maximum number of characters allowed for phone numbers.',        'note_content' => '<p class="mb-1"><strong>Para sa lokal na format (walang country code):</strong> Itakda ang min/max batay sa haba ng phone number ng iyong bansa (hal., 8-15 para sa karamihan ng mga bansa).</p><p class="mb-0"><strong>Para sa internasyonal na format (may naka-enable na country code):</strong> Inirerekomenda min: 7, max: 20. Kasama nito ang mga country code (1-4 digit) + mga phone number (karaniwang 6-15 digit).</p>',
    ],
];
